<?php
/**
 * 百福核心类
 * copyright http://www.jccrj.cn/
 */
class Baifu {

    /**
     * 百福框架初始化
     * @access public
     * @return void
     */
    public static function start($isauto=true) {
    	if(version_compare(PHP_VERSION,'5.2.0','<'))  die('require PHP > 5.2.0 !');
		define ( 'IS_CGI', substr ( PHP_SAPI, 0, 3 ) == 'cgi' ? true : false );
		define ( 'IS_WIN', strstr ( PHP_OS, 'WIN' ) ? true : false );
		define ( 'IS_CLI', PHP_SAPI == 'cli' ? true : false );
		defined ( 'APP_DEBUG' ) or define ( 'APP_DEBUG', false );
		defined ( 'BAIFU_VERSION' ) or define ( 'BAIFU_VERSION', '1.0.0' );
		defined ( 'BAIFU_PATH' ) or define ( 'BAIFU_PATH', str_replace ( "\\", '/', dirname ( dirname ( __FILE__ ) ) ) . '/' );
		defined ( 'BAIFU_LIBRARY_PATH' ) or define ( 'BAIFU_LIBRARY_PATH', BAIFU_PATH . 'library/' );
		defined ( 'APP_PATH' ) or define ( 'APP_PATH', str_replace ( "\\", '/', dirname ( $_SERVER ['SCRIPT_FILENAME'] ) ) . '/' );
		defined ( 'APP_COMMON_PATH' ) or define ( 'APP_COMMON_PATH', APP_PATH . 'common/' );
		defined ( 'APP_MODULES_PATH' ) or define ( 'APP_MODULES_PATH', APP_PATH . 'modules/' );
		defined ( 'APP_LIBRARY_PATH' ) or define ( 'APP_LIBRARY_PATH', APP_PATH . 'library/' );
		defined ( 'APP_PLUGIN_PATH' ) or define ( 'APP_PLUGIN_PATH', APP_PATH . 'plugin/' );
		defined ( 'APP_CONFIG_PATH' ) or define ( 'APP_CONFIG_PATH', APP_PATH . 'config/' );
		defined ( 'APP_LANG_PATH' ) or define ( 'APP_LANG_PATH', APP_PATH . 'lang/' );
		defined ( 'APP_VIEW_PATH' ) or define ( 'APP_VIEW_PATH', APP_PATH . 'view/' );
		defined ( 'APP_FILE_PATH' ) or define ( 'APP_FILE_PATH', APP_PATH . 'file/' );
		defined ( 'APP_FILE_LOG_PATH' ) or define ( 'APP_FILE_LOG_PATH', APP_FILE_PATH . 'logs/' );
		defined ( 'APP_FILE_TEMPLATE_PATH' ) or define ( 'APP_FILE_TEMPLATE_PATH', APP_FILE_PATH . 'template/' );
		defined ( 'APP_FILE_DATA_PATH' ) or define ( 'APP_FILE_DATA_PATH', APP_FILE_PATH . 'data/' );
		defined ( 'APP_FILE_CACHE_PATH' ) or define ( 'APP_FILE_CACHE_PATH', APP_FILE_PATH . 'cache/' );
		defined ( 'APP_FILE_QUERY_PATH' ) or define ( 'APP_FILE_QUERY_PATH', APP_FILE_PATH . 'query/' );
		defined ( 'APP_FILE_TAG_PATH' ) or define ( 'APP_FILE_TAG_PATH', APP_FILE_PATH . 'tag/' );
		defined ( 'APP_FILE_UPLOAD_DIR' ) or define ( 'APP_FILE_UPLOAD_DIR', 'file/upload/' );
		defined ( 'APP_FILE_UPLOAD_PATH' ) or define('APP_FILE_UPLOAD_PATH',     APP_PATH.APP_FILE_UPLOAD_DIR);
		require_once BAIFU_LIBRARY_PATH.'config.class.php';
		$list = array(
			BAIFU_PATH . 'config/default.php',
			APP_CONFIG_PATH . 'default.php',
			BAIFU_PATH . 'config/autoload.php',
			APP_CONFIG_PATH . 'autoload.php',
		);
		Config::load($list);
		$list = array (
			BAIFU_PATH.'functions/common.php',
			BAIFU_LIBRARY_PATH . 'plugin/plugin.class.php',
			BAIFU_LIBRARY_PATH . 'log/logger.class.php',
			BAIFU_LIBRARY_PATH . 'cookie.class.php',
			BAIFU_LIBRARY_PATH . 'session/session.class.php',
		);
		foreach ( $list as $file ) {
			if (file_exists( $file )) {
				require_once  $file ;
			}
		}
		set_include_path(get_include_path() . PATH_SEPARATOR . BAIFU_LIBRARY_PATH);
		register_shutdown_function(array('Baifu','shutdown'));
        set_error_handler(array('Baifu','error'));
        set_exception_handler(array('Baifu','exception'));
        spl_autoload_register(array('Baifu', 'autoload'));
		date_default_timezone_set(Config::get('default.timezone'));
        define('NOW',      time());
    	if(Config::get('default.gzip') && function_exists('ob_gzhandler')) {
			ob_start('ob_gzhandler');
		} else {
			ob_start();
		}
		if(version_compare(PHP_VERSION,'5.4.0','<')) {
		    ini_set('magic_quotes_runtime',0);
		    define('MAGIC_QUOTES_GPC',get_magic_quotes_gpc()?true:false);
		    if(MAGIC_QUOTES_GPC){
		    	$_GET = New_stripslashes ( $_GET );
		    	$_POST = New_stripslashes ( $_POST );
		    	$_COOKIE = New_stripslashes ( $_COOKIE );
		    }
		}else{
		    define('MAGIC_QUOTES_GPC',false);
		}
        defined ( 'IP' ) or define ( 'IP', GetIP () );
		defined ( 'WEB_HTTP_REFERER' ) or define ( 'WEB_HTTP_REFERER', isset ( $_SERVER ['HTTP_REFERER'] ) ? $_SERVER ['HTTP_REFERER'] : '' );
		defined ( 'WEB_SCRIPT_NAME' ) or define ( 'WEB_SCRIPT_NAME', isset ( $_SERVER ['SCRIPT_NAME'] ) ? $_SERVER ['SCRIPT_NAME'] : preg_replace ( '/(.*)\.php(.*)/i', "\\1.php", $_SERVER ['PHP_SELF'] ) );
		defined ( 'WEB_QUERY_STRING' ) or define ( 'WEB_QUERY_STRING', FilterUnsafeChars ( $_SERVER ['QUERY_STRING'] ) );
		defined ( 'WEB_PATH_INFO' ) or define ( 'WEB_PATH_INFO', isset ( $_SERVER ['PATH_INFO'] ) ? FilterUnsafeChars ( $_SERVER ['PATH_INFO'] ) : '' );
		defined ( 'WEB_SERVER_NAME' ) or define ( 'WEB_SERVER_NAME', isset ( $_SERVER ['SERVER_NAME'] ) ? $_SERVER ['SERVER_NAME'] : preg_replace ( "/([^:]*)[:0-9]*/i", "\\1", $_SERVER ['HTTP_HOST'] ) );
		defined ( 'WEB_SCHEME' ) or define ( 'WEB_SCHEME', $_SERVER ['SERVER_PORT'] == '443' ? 'https://' : 'http://' );
		$root = str_replace ( '\\', '/', dirname ( WEB_SCRIPT_NAME ) );
		$root = strlen ( $root ) > 1 ? $root."/" : "/";
		defined ( 'WEB_ROOT' ) or define ( 'WEB_ROOT', $root );
		defined ( 'WEB_URL' ) or define ( 'WEB_URL', WEB_SCHEME . $_SERVER ['HTTP_HOST'] . WEB_ROOT );
		defined ( 'WEB_RELATE_URL' ) or define ( 'WEB_RELATE_URL', isset ( $_SERVER ['REQUEST_URI'] ) ? FilterUnsafeChars ( $_SERVER ['REQUEST_URI'] ) : WEB_SCRIPT_NAME . (WEB_QUERY_STRING ? '?' . WEB_QUERY_STRING : WEB_PATH_INFO) );
		defined ( 'WEB_CURRENT_URL' ) or define ( 'WEB_CURRENT_URL', WEB_SCHEME . $_SERVER ['HTTP_HOST'] . WEB_RELATE_URL );
		defined ( 'REQUEST_TIME' ) or define ( 'REQUEST_TIME', $_SERVER ['REQUEST_TIME'] );
		defined ( 'REQUEST_METHOD' ) or define ( 'REQUEST_METHOD', $_SERVER ['REQUEST_METHOD'] );
		defined ( 'IS_GET' ) or define ( 'IS_GET', REQUEST_METHOD == 'GET' ? true : false );
		defined ( 'IS_POST' ) or define ( 'IS_POST', REQUEST_METHOD == 'POST' ? true : false );
		defined ( 'IS_PUT' ) or define ( 'IS_PUT', REQUEST_METHOD == 'PUT' ? true : false );
		defined ( 'IS_DELETE' ) or define ( 'IS_DELETE', REQUEST_METHOD == 'DELETE' ? true : false );
		defined ( 'IS_AJAX' ) or define ( 'IS_AJAX', ((isset ( $_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') || !empty($_REQUEST['ajax'])) ? true : false);
    	$_GET = FilterSql ( $_GET );
		$_POST = FilterSql ( $_POST );
		$_COOKIE = FilterSql ( $_COOKIE );
    	$_REQUEST = array_merge($_POST,$_GET);
    	foreach (array('m','c','a') as $v){
			Baifu::set($v,$_REQUEST[$v]?$_REQUEST[$v]:Config::get('default.'.$v));
    	}
    	Session::instance();
        if($isauto){
	        self::run();
        }
    }
    /**
     * 根据当前的MCA执行控制器方法
     */
    public static function run() {
    	$c = Baifu::get ( 'c' );
		$module = Baifu::get ( 'm' );
		$action = Baifu::get ( 'a' );
     	if(!preg_match('/^[A-Za-z](\w)*$/',$c)){
            $controller  =  false;
        }else{
        	RequireOnce( APP_MODULES_PATH . $module . '/controller/' . $c . 'controller.class.php' );
			$class = $c . 'Controller';
			if (class_exists ( $class, false )) {
				$controller = new $class ();
			}
        }
		
		if (! $controller) {
			Halt ( '控制器不存在:' . $c );
		}
        try{
            if(!preg_match('/^[A-Za-z](\w)*$/',$action)){
                throw new ReflectionException();
            }
            $method =   new ReflectionMethod($controller, $action);
            if($method->isPublic()) {
                $class  =   new ReflectionClass($controller);
               	$method->invoke($controller);
            }else{
                throw new ReflectionException();
            }
        } catch (ReflectionException $e) {
            $method = new ReflectionMethod($controller,'__call');
            $method->invokeArgs($controller,array($action,''));
        }
        return ;
    
    }

	
	protected static $modules = array ();
    /**
     * 自动加载类
     * @param string $class 类名
     * @return void
     */
    protected static function autoload($class) {
    	$class=strtolower($class);
    	foreach ( Config::type ( 'autoload' ) as $k => $path ) {
			if ($k == $class) {
				if (file_exists ( $path )) {
					require_once $path;
					return;
				} else {
					break;
				}
			}
		}
    	if(!self::$modules){
	        $files = glob ( APP_MODULES_PATH . '*' );
			foreach ( $files as $v ) {
				if (is_dir ( $v )) {
					self::$modules[] = str_replace("\\", '/', $v) . '/';
				}
			}
    	}
        $file       =   $class.'.class.php';
        $types=array('service','model','field','table','controller','plugin','encrypt','cache','db');
        foreach ($types as $type){
        	if(substr($class, strrpos($class, $type))==$type){
        		if($type=='field'||$type=='table'){
        			$type='model';
        		}
        		$dirs=self::$modules;
        		array_unshift($dirs,APP_MODULES_PATH.Baifu::get ( 'm' ).'/');
        		array_unshift($dirs,BAIFU_LIBRARY_PATH);
	        	foreach ($dirs as $dir){
	        		$path=$dir.$type.'/'.$file;
	            	if (file_exists($path)) {
			            require_once $path;
			            return;
	            	}
	            }
        	}
        }
    }
    /**
	 * 全局变量
	 */
    public static $data = array();
	/**
	 * 获取全局变量
	 * @param string $key 键
	 * @param mixed $value 值
	 * @return mixed
	 */
	public static function get($key = null, $default = null) {
		if (strpos ( $key, '.' ) !== false) {
			list ( $group, $key ) = explode ( '.', $key );
		} else {
			$group = 'GLOBAL';
		}
		$value = self :: $data[$group] [$key];
		if (is_null ( $value ))
			$value = $default;
		return $value;
	}
	
	/**
	 * 设置全局变量
	 * @param string|array $key 键
	 * @param mixed $value 值
	 * @return mixed
	 */
	public static function set($key = null, $value = null) {
		if (is_array ( $value )) {
			self :: $data [$key] = $value;
		} else {
		
			if(is_null($value)){
				unset(self :: $data ['GLOBAL'] [$key]);
			}else{
				self :: $data ['GLOBAL'] [$key] = $value;
			}
		}
	}
	/**
     * 实例集合
     */
	protected static $instances = array();
	/**
	 * 取得对象实例 
	 * @param string $class 对象类名
	 * @param array $args 构造参数
	 * @param string $method 方法名
	 * @return object
	 */
	public static function instance($class, $args = array(), $method = '') {
		$identify = $class . serialize ( $args ) . $method;
		if (! isset ( self::$instances [$identify] )) {
			if (class_exists ( $class )) {
				if (empty ( $args )) {
					$o = new $class ();
				} else {
					$ref = new ReflectionClass ( $class );
					$o = $ref->newInstanceArgs ( $args );
				}
				if (! empty ( $method ) && method_exists ( $o, $method ))
					self::$instances [$identify] = call_user_func_array ( array (&$o, $method ) );
				else
					self::$instances [$identify] = $o;
			} else {
				Halt ( '类不存在:' . $class );
			}
		}
		return self::$instances [$identify];
	}

    
	/**
     * 日志
     * @access public
     * @param string $message  备注
     * @param string $type  类型
     * @param string $issave  是否保存
     * @return void
     */
    public static function log($message,$type='info',$issave=FALSE)
    {
        self::$data['log'][$type][]  =  $message;
    	if(IS_AJAX || $issave) {
            Logger::instance()->write($message, $type);
        }
    }
	/**
     * 获取指定类型的日志
     * @access public
     * @param string $type  类型
     * @return void
     */
    public static function getLog($type)
    {
        return isset(self::$data['log'][$type])?self::$data['log'][$type]:array();
    }
   
    /**
     * 记录调试
     * @access public
     * @param string $name  要标记的位置名称
     * @return void
     */
    public static function mark($name)
    {
        self::$data['time'][$name]  =  microtime(TRUE);
        if(MEMORY_LIMIT_ON) {
            self::$data['memory'][$name] = memory_get_usage();
            self::$data['peak'][$name] = function_exists('memory_get_peak_usage')?memory_get_peak_usage(): self::$data['memory'][$name];
        }
    }

    /**
     * 获取使用时间
     * @access public
     * @param string $start  开始标记的名称
     * @param string $end  结束标记的名称
     * @param integer $decimals  时间的小数位
     * @return integer
     */
    public static function getTime($start,$end,$decimals = 6)
    {
        if ( ! isset(self::$data['time'][$start]))
            return '';
        if ( ! isset(self::$data['time'][$end]))
            self::$data['time'][$end] = microtime(TRUE);
        return number_format(self::$data['time'][$end] - self::$data['time'][$start], $decimals);
    }

    /**
     * 获取使用内存
     * @access public
     * @param string $start  开始标记的名称
     * @param string $end  结束标记的名称
     * @return integer
     */
    public static function getMemory($start,$end)
    {
        if(!MEMORY_LIMIT_ON)
            return '';
        if ( ! isset(self::$data['memory'][$start]))
            return '';
        if ( ! isset(self::$data['memory'][$end]))
            self::$data['memory'][$end] = memory_get_usage();
        return number_format((self::$data['memory'][$end] - self::$data['memory'][$start])/1024);
    }

    /**
     * 获取使用内存峰值
     * @access public
     * @param string $start  开始标记的名称
     * @param string $end  结束标记的名称
     * @return integer
     */
    public static function getMemoryPeak($start,$end) {
        if(!MEMORY_LIMIT_ON)
            return '';
        if ( ! isset(self::$data['peak'][$start]))
            return '';
        if ( ! isset(self::$data['peak'][$end]))
            self::$data['peak'][$end] = function_exists('memory_get_peak_usage')?memory_get_peak_usage(): memory_get_usage();
        return number_format(max(self::$data['peak'][$start],self::$data['peak'][$end])/1024);
    }
	
    /**
     * 记录查询开始时间
     */
    public static function db_query_start(){
    	if(!APP_DEBUG) return;
    	self::mark('db_query_start');
    }
    /**
     * 记录查询语句和使用时间
     */
	public static function db_query_end($param){
		if(!APP_DEBUG) return;
    	self::mark('db_query_end');
    	$message='SQL:'.$param.' TIME:'.self::getTime('db_query_start', 'db_query_end');
    	self::log($message,'sql');
    }
    /**
     * 记录查询错误
     */
	public static function db_sql_error($message){
		if(!APP_DEBUG) return;
    	self::log($message,'sql_error');
    }
    
	/**
     * 自定义异常处理
     * @access public
     * @param mixed $e 异常对象
     */
    public static function exception($e) {
		$error = array ();
		$error ['message'] = $e->getMessage ();
		$trace = $e->getTrace ();
		if ('throw_exception' == $trace [0] ['function']) {
			$error ['file'] = $trace [0] ['file'];
			$error ['line'] = $trace [0] ['line'];
		} else {
			$error ['file'] = $e->getFile ();
			$error ['line'] = $e->getLine ();
		}
		Logger::instance ()->error ( $error ['message'] );
		Halt ( $error );
	}

    /**
     * 自定义错误处理
     * @access public
     * @param int $type 错误类型
     * @param string $string 错误信息
     * @param string $file 错误文件
     * @param int $line 错误行号
     * @return void
     */
    public static function error($type, $string, $file, $line) {
      	$message = "error: $string file: $file line: $line";
    	switch ($type) {
          case E_ERROR:
          case E_PARSE:
          case E_CORE_ERROR:
          case E_COMPILE_ERROR:
          case E_USER_ERROR:
            ob_end_clean();
            if(Config::get('log.errorlog')) Logger::error($message);
            Halt($message);
            break;
          case E_STRICT:
          case E_USER_WARNING:
          case E_USER_NOTICE:
          default:
            break;
      }
    }
    
    /**
     * 程序运行结束后执行
     */
    public static function shutdown() {
    	$e = error_get_last();
    	if ($e) {
            switch($e['type']){
              case E_ERROR:
              case E_PARSE:
              case E_CORE_ERROR:
              case E_COMPILE_ERROR:
              case E_USER_ERROR:  
                ob_end_clean();
                Halt($e);
                break;
            }
        }
        if(!APP_DEBUG || Baifu::get('hidedebug')||Baifu::get('isajax')||IS_AJAX||empty(self::$data['log'])) return;
    	echo <<<HTML
<div class="tab">
<h3>调试信息</h3>
HTML;
foreach (self::$data['log'] as $k=>$v){
echo <<<HTML
<div class="panel panel-warning">
<div class="panel-header">
<div class="panel-title">$k</div>
</div>
<ul class="list-group">
HTML;
foreach ($v as $i=>$message){
	$i++;
echo <<<HTML
<li class="list-group-item">$i: $message</li>
HTML;
}
echo <<<HTML
</ul>
</div>
HTML;
}
echo <<<HTML
</div>
HTML;
    }
}
