<?php
defined ( 'BAIFU_PATH' ) or exit ( 'Access Denied' );
/**
 * 数据库基类
 */
class Db {
	/**
	 * 名称
	 */
	protected $name = '';
	
	/**
	 * 设置
	 */
	protected $config = array ();
	/**
	 * 架构函数
	 * @access public
	 */
	public function __construct() {
	
	}
	/**
	 * 设置数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @param mixed $value 值
	 * @return void
	 */
	public function __set($name, $value) {
		$this->config [$name] = $value;
	}
	
	/**
	 * 获取数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return mixed
	 */
	public function __get($name) {
		return isset ( $this->config [$name] ) ? $this->config [$name] : null;
	}
	
	/**
	 * 检测数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return boolean
	 */
	public function __isset($name) {
		return isset ( $this->config [$name] );
	}
	
	/**
	 * 销毁数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return void
	 */
	public function __unset($name) {
		unset ( $this->config [$name] );
	}
	
	protected static $default = array ('db_type' => 'mysql', 'db_charset' => 'utf8', 'persist' => false, 'master' => array (), 'slave' => array () );
	public $sql_formats = array ('insert' => 'INSERT INTO [TABLE] [VALUES][LOCK][COMMENT]', 'replace' => 'REPLACE INTO [TABLE] [VALUES][LOCK][COMMENT]', 'delete' => 'DELETE FROM [TABLE][WHERE][ORDER][LIMIT][LOCK][COMMENT]', 'update' => 'UPDATE [TABLE] [SET][WHERE][ORDER][LIMIT][LOCK][COMMENT]', 'select' => 'SELECT[DISTINCT] [FIELD] FROM [TABLE][JOIN][WHERE][GROUP][HAVING][ORDER][LIMIT][UNION][LOCK][COMMENT]' );
	protected $sql_keywords = array ('DISTINCT', 'FIELD', 'TABLE', 'JOIN', 'WHERE', 'GROUP', 'HAVING', 'ORDER', 'LIMIT', 'UNION', 'COMMENT', 'SET', 'LOCK', 'VALUES' );
	protected $sql_where_op = array ('eq' => '=', 'neq' => '<>', 'gt' => '>', 'egt' => '>=', 'lt' => '<', 'elt' => '<=', 'notlike' => 'NOT LIKE', 'like' => 'LIKE', 'in' => 'IN', 'notin' => 'NOT IN' );
	protected $sql = '';
	protected $error = '';
	protected $connections = array ();
	protected $connection = null;
	protected $transactions = 0;
	protected $resource = null;
	protected $insert_id = null;
	protected $num_rows = 0;
	/** 
	 * 取得类实例
	 * @static
	 * @access public
	 * @return Db 返回类实例
	 */
	public static function instance($config = array()) {
		$args = func_get_args ();
		static $_instance = array ();
		$identify = Guid ( $args );
		if (! isset ( $_instance [$identify] )) {
			$config = self::parseConfig ( $config );
			$o = new Db ();
			$o->init ( $config );
			$_instance [$identify] = $o;
		}
		return $_instance [$identify];
	}
	
	/**
	 * 解析配置
	 * @access public
	 * @param array $config 自定义配置
	 * @return string
	 */
	public static function parseConfig($config = array()) {
		if (is_string ( $config ))
			$config = array ('db_type' => $config );
		return array_merge ( self::$default, Config::load ( 'database' ), array_change_key_case ( $config ) );
	}
	public function init($config = array()) {
		$this->config = array_merge ( $this->config, $config );
	}
	
	/**
	 * 初始化数据库连接
	 * @access protected
	 * @param boolean $master 主服务器
	 * @return void
	 */
	protected function initConnect($master = true) {
		return $this->connection = $this->connect ( $this->config );
	}
	
	/**
	 * 解析值
	 * @access protected
	 * @param mixed $value
	 * @return string
	 */
	protected function parseValue($value) {
		if (is_string ( $value )) {
			$value = '\'' . $this->escapeString ( $value ) . '\'';
		} elseif (isset ( $value ['isexp'] )) {
			$value = $this->escapeString ( $value ['value'] );
		} elseif (is_array ( $value )) {
			$value = array_map ( array ($this, 'parseValue' ), $value );
		} elseif (is_bool ( $value )) {
			$value = $value ? '1' : '0';
		} elseif (is_null ( $value )) {
			$value = 'null';
		}
		return $value;
	}
	
	/**
	 * 生成SQL语句
	 * @access public
	 * @param array $options 表达式
	 * @return string
	 */
	public function buildSql($options, $type = 'select') {
		$result = isset ( $this->sql_formats [$type] ) ? $this->sql_formats [$type] : $type;
		foreach ( $this->sql_keywords as $k ) {
			$method_name = 'buildSql' . ucfirst ( strtolower ( $k ) );
			if (method_exists ( $this, $method_name )) {
				$result = str_replace ( '[' . strtoupper ( $k ) . ']', $this->$method_name ( $options [strtolower ( $k )] ), $result );
			}
		}
		return $result;
	}
	/**
	 * 生成锁机制
	 * @access protected
	 * @return string
	 */
	protected function buildSqlLock($lock = false) {
		if (! $lock)
			return '';
		return ' FOR UPDATE ';
	}
	
	/**
	 * 生成SQL:distinct
	 * @access protected
	 * @param mixed $distinct
	 * @return string
	 */
	protected function buildSqlDistinct($distinct) {
		return ! empty ( $distinct ) ? ' DISTINCT ' : '';
	}
	/**
	 * 生成SQL:values
	 * @access protected
	 * @param mixed $distinct
	 * @return string
	 */
	protected function buildSqlValues($data) {
		if (empty ( $data ))
			return '';
		$result = '';
		$values = $fields = array ();
		foreach ( $data as $key => $val ) {
			if (is_scalar ( $val ) || is_null ( ($val) )) {
				$fields [] = $this->parseKey ( $key );
				$values [] = is_array ( $val ) && $val ['isexp'] ? $val ['value'] : $this->parseValue ( $val );
			}
		}
		$result = ' (' . implode ( ',', $fields ) . ') VALUES (' . implode ( ',', $values ) . ')';
		return $result;
	}
	/**
	 * 生成set
	 * @access protected
	 * @param array $data
	 * @return string
	 */
	protected function buildSqlSet($data) {
		foreach ( $data as $key => $val ) {
			if (is_array ( $val ) && isset ( $val ['isexp'] )) {
				$set [] = $this->parseKey ( $key ) . '=' . $val ['value'];
			} elseif (is_scalar ( $val ) || is_null ( ($val) )) {
				$set [] = $this->parseKey ( $key ) . '=' . $this->parseValue ( $val );
			}
		}
		return ' SET ' . implode ( ',', $set );
	}
	
	/**
	 * 生成field
	 * @access protected
	 * @param mixed $fields
	 * @return string
	 */
	protected function buildSqlField($fields) {
		if (is_string ( $fields ) && strpos ( $fields, ',' )) {
			$fields = explode ( ',', $fields );
		}
		if (is_array ( $fields )) {
			$array = array ();
			foreach ( $fields as $key => $field ) {
				if (! is_numeric ( $key ))
					$array [] = $this->parseKey ( $key ) . ' AS ' . $this->parseKey ( $field );
				else
					$array [] = $this->parseKey ( $field );
			}
			$fieldsStr = implode ( ',', $array );
		} elseif (is_string ( $fields ) && ! empty ( $fields )) {
			$fieldsStr = $this->parseKey ( $fields );
		} else {
			$fieldsStr = '*';
		}
		return $fieldsStr;
	}
	
	/**
	 * 生成table
	 * @access protected
	 * @param mixed $table
	 * @return string
	 */
	protected function buildSqlTable($tables) {
		$result = array ();
		if (is_string ( $tables )) {
			$tables = explode ( ',', $tables );
		}
		foreach ( $tables as $k => $v ) {
			if (! is_numeric ( $k )) {
				$result [] = $this->parseKey ( $k ) . ' ' . $this->parseKey ( $v );
			} else {
				$result [] = $this->parseKey ( $v );
			}
		}
		return implode ( ',', $result );
	}
	
	/**
	 * 生成where
	 * @access protected
	 * @param mixed $where
	 * @return string
	 */
	protected function buildSqlWhere($where) {
		$result = '';
		foreach ( $where as $k => $v ) {
			if (is_string ( $k )) {
				if (is_array ( $v ) && ! isset ( $v ['type'] )) {
					$v = array ('type' => isset ( $v [2] ) ? $v [2] : 'and', 'field' => $k, 'op' => $v [0], 'value' => $v [1] );
				} elseif ($k == '_string') {
					$v = array ('type' => 'and', 'string' => $v );
				} else {
					$v = array ('type' => 'and', 'field' => $k, 'op' => 'eq', 'value' => $v );
				}
			} else if (is_numeric ( $k ) && is_string ( $v )) {
				$v = array ('type' => 'and', 'string' => $v );
			}
			$v ['type'] = strtoupper ( $v ['type'] );
			if (empty ( $result )) {
				$v ['type'] = '';
			}
			if (isset ( $v ['where'] )) {
				$result .= ' ' . $v ['type'] . ' (' . $this->buildSqlWhere ( $v ['where'] ) . ')';
			} elseif (isset ( $v ['string'] )) {
				$result .= ' ' . $v ['type'] . ' ' . $v ['string'];
			} else {
				switch (strtolower ( $v ['op'] )) {
					case 'in' :
						if (empty ( $v ['isexp'] )) {
							if (is_string ( $v ['value'] )) {
								$v ['value'] = explode ( ',', $v ['value'] );
							}
							$v ['value'] = implode ( ',', $this->parseValue ( $v ['value'] ) );
						}
						$result .= ' ' . $v ['type'] . ' ' . $this->parseKey ( $v ['field'] ) . ' ' . $this->sql_where_op [$v ['op']] . ' (' . $v ['value'] . ')';
						break;
					case 'between' :
						$result .= ' ' . $v ['type'] . ' (' . $this->parseKey ( $v ['field'] ) . ' ' . $this->sql_where_op [$v ['op']] . ' ' . $this->parseValue ( $v ['value'] ) . ' AND ' . $this->parseValue ( $v ['value1'] ) . ')';
						break;
					default :
						if (empty ( $v ['isexp'] )) {
							$v ['value'] = $this->parseValue ( $v ['value'] );
						}
						if (! isset ( $this->sql_where_op [$v ['op']] )) {
							$op = $v ['op'];
						} else {
							$op = $this->sql_where_op [$v ['op']];
						}
						$result .= ' ' . $v ['type'] . ' ' . $this->parseKey ( $v ['field'] ) . ' ' . $op . ' ' . $v ['value'];
				}
			}
		}
		$result = trim ( $result );
		return empty ( $result ) ? '' : ' WHERE ' . $result;
	}
	
	/**
	 * 生成limit
	 * @access protected
	 * @param mixed $lmit
	 * @return string
	 */
	protected function buildSqlLimit($limit) {
		return ! empty ( $limit ) ? ' LIMIT ' . $limit . ' ' : '';
	}
	
	/**
	 * 生成join
	 * @access protected
	 * @param mixed $join
	 * @return string
	 */
	protected function buildSqlJoin($join) {
		$result = '';
		foreach ( $join as $v ) {
			$result .= ' ' . $v ['type'] . ' ' . $v ['table'] . ' ' . $v ['on'];
		}
		return $result;
	}
	
	/**
	 * 生成order
	 * @access protected
	 * @param mixed $order
	 * @return string
	 */
	protected function buildSqlOrder($order) {
		if (is_array ( $order )) {
			$array = array ();
			foreach ( $order as $key => $val ) {
				if (is_numeric ( $key )) {
					$array [] = $this->parseKey ( $val );
				} else {
					$array [] = $this->parseKey ( $key ) . ' ' . $val;
				}
			}
			$order = implode ( ',', $array );
		}
		return ! empty ( $order ) ? ' ORDER BY ' . $order : '';
	}
	
	/**
	 * 生成SQL:group
	 * @access protected
	 * @param mixed $group
	 * @return string
	 */
	protected function buildSqlGroup($group) {
		return ! empty ( $group ) ? ' GROUP BY ' . $group : '';
	}
	
	/**
	 * 生成having
	 * @access protected
	 * @param string $having
	 * @return string
	 */
	protected function buildSqlHaving($having) {
		return ! empty ( $having ) ? ' HAVING ' . $having : '';
	}
	
	/**
	 * 生成comment
	 * @access protected
	 * @param string $comment
	 * @return string
	 */
	protected function buildSqlComment($comment) {
		return ! empty ( $comment ) ? ' /* ' . $comment . ' */' : '';
	}
	
	/**
	 * 生成union
	 * @access protected
	 * @param mixed $union
	 * @return string
	 */
	protected function buildSqlUnion($union) {
		if (empty ( $union ))
			return '';
		foreach ( $union as $k => $v ) {
			$sql [] = $v ['type'] . ' ' . (is_array ( $v ['options'] ) ? $this->buildSql ( $v ['options'], 'select' ) : $v ['options']);
		}
		return implode ( ' ', $sql );
	}
	
	/**
	 * 插入记录
	 * @access public
	 * @param mixed $data 数据
	 * @param array $options 参数表达式
	 * @param boolean $replace 是否replace
	 * @return false | integer
	 */
	public function insert($data, $options = array(), $isreplace = false) {
		$options ['values'] = $data;
		$sql = $this->buildSql ( $options, $isreplace ? 'replace' : 'insert' );
		return $this->execute ( $sql );
	}
	
	/**
	 * 更新记录
	 * @access public
	 * @param mixed $data 数据
	 * @param array $options 表达式
	 * @return false | integer
	 */
	public function update($data, $options) {
		$options ['set'] = $data;
		$sql = $this->buildSql ( $options, 'update' );
		return $this->execute ( $sql );
	}
	
	/**
	 * 删除记录
	 * @access public
	 * @param array $options 表达式
	 * @return false | integer
	 */
	public function delete($options = array()) {
		$sql = $this->buildSql ( $options, 'delete' );
		return $this->execute ( $sql );
	}
	
	/**
	 * 查找记录
	 * @access public
	 * @param array $options 表达式
	 * @return mixed
	 */
	public function select($options = array()) {
		$sql = $this->buildSql ( $options, 'select' );
		$cache = isset ( $options ['cache'] ) ? $options ['cache'] : false;
		if ($cache !== false) {
			$key = is_string ( $cache ['key'] ) ? $cache ['key'] : md5 ( $sql );
			$key = 'select_' . $key;
			$value = Cache::instance ( $cache )->get ( $key );
			if ($value !== false) {
				return $value;
			}
		}
		$result = $this->query ( $sql );
		if ($cache !== false && $result !== false) {
			Cache::instance ( $cache )->set ( $key, $result );
		}
		return $result;
	}
	
	/**
	 * 获取当前查询的sql语句 
	 * @access public
	 * @return string
	 */
	public function getSql() {
		return $this->sql;
	}
	
	/**
	 * 获取当前插入的ID
	 * @access public
	 * @return string
	 */
	public function getInsertId() {
		return $this->insert_id;
	}
	
	/**
	 * 获取最近的错误信息
	 * @access public
	 * @return string
	 */
	public function getError() {
		return $this->error;
	}
	
	/**
	 * 连接数据库
	 * @access public
	 */
	public function connect($config = '', $linkNum = 0, $force = false) {
		if (! isset ( $this->connections [$linkNum] )) {
			if (empty ( $config ))
				$config = $this->config;
			$host = $config ['db_host'] . ($config ['db_port'] ? ":{$config['db_port']}" : '');
			if ($config ['persist']) {
				$this->connections [$linkNum] = mysql_pconnect ( $host, $config ['db_user'], $config ['db_pwd'] );
			} else {
				$this->connections [$linkNum] = mysql_connect ( $host, $config ['db_user'], $config ['db_pwd'], true );
			}
			if (! $this->connections [$linkNum] || (! empty ( $config ['db_name'] ) && ! mysql_select_db ( $config ['db_name'], $this->connections [$linkNum] ))) {
				echo mysql_error ();
				exit ();
			}
			$dbVersion = mysql_get_server_info ( $this->connections [$linkNum] );
			mysql_query ( "SET NAMES '" . $config ['db_charset'] . "'", $this->connections [$linkNum] );
			if ($dbVersion > '5.0.1') {
				mysql_query ( "SET sql_mode=''", $this->connections [$linkNum] );
			}
		}
		return $this->connections [$linkNum];
	}
	/**
	 * 取得数据库的版本
	 * @access public
	 * @return string
	 */
	public function version() {
		$this->initConnect ( false );
		if (! $this->connection)
			return false;
		return mysql_get_server_info ( $this->connection );
	}
	/**
	 * 释放查询结果
	 * @access public
	 */
	public function free() {
		if (is_resource ( $this->resource )) {
			mysql_free_result ( $this->resource );
			$this->resource = null;
		}
	}
	
	/**
	 * 关闭数据库
	 * @access public
	 * @return void
	 */
	public function close() {
		if ($this->connection) {
			mysql_close ( $this->connection );
		}
		$this->connection = null;
	}
	
	/**
	 * 执行查询 返回数据集
	 * @access public
	 * @param string $str  sql指令
	 * @return mixed
	 */
	public function query($str) {
		if (0 === stripos ( $str, 'call' )) {
			$this->close ();
		}
		$this->initConnect ( false );
		if (! $this->connection)
			return false;
		$this->sql = $str;
		if ($this->resource) {
			$this->free ();
		}
		Baifu::db_query_start();
        $this->resource = mysql_query($str, $this->connection);
        Baifu::db_query_end($this->sql);
        if (false === $this->resource) {
			$this->error ();
			return false;
		} else {
			$this->num_rows = mysql_num_rows ( $this->resource );
			return $this->fetch_all ();
		}
	}
	
	/**
	 * 执行语句
	 * @access public
	 * @param string $str  sql指令
	 * @return integer|false
	 */
	public function execute($str) {
		$this->initConnect ( true );
		if (! $this->connection)
			return false;
		$this->sql = $str;
		if ($this->resource) {
			$this->free ();
		}
		Baifu::db_query_start();
		$result = mysql_query ( $str, $this->connection );
		Baifu::db_query_end($this->sql);
		if (false === $result) {
			$this->error ();
			return false;
		} else {
			$this->num_rows = mysql_affected_rows ( $this->connection );
			$this->insert_id = mysql_insert_id ( $this->connection );
			return $this->num_rows;
		}
	}
	
	/**
	 * 启动事务
	 * @access public
	 * @return void
	 */
	public function beginTransaction() {
		$this->initConnect ( true );
		if (! $this->connection)
			return false;
		if ($this->transactions == 0) {
			mysql_query ( 'START TRANSACTION', $this->connection );
		}
		$this->transactions ++;
		return;
	}
	
	/**
	 * 提交事务
	 * @access public
	 * @return boolen
	 */
	public function commit() {
		if ($this->transactions > 0) {
			$result = mysql_query ( 'COMMIT', $this->connection );
			$this->transactions = 0;
			if (! $result) {
				$this->error ();
				return false;
			}
		}
		return true;
	}
	
	/**
	 * 事务回滚
	 * @access public
	 * @return boolen
	 */
	public function rollback() {
		if ($this->transactions > 0) {
			$result = mysql_query ( 'ROLLBACK', $this->connection );
			$this->transactions = 0;
			if (! $result) {
				$this->error ();
				return false;
			}
		}
		return true;
	}
	/**
	 * SQL指令安全过滤
	 * @access public
	 * @param string $str  SQL字符串
	 * @return string
	 */
	public function escapeString($str) {
		if ($this->connection) {
			return mysql_real_escape_string ( $str, $this->connection );
		} else {
			return mysql_escape_string ( $str );
		}
	}
	
	/**
	 * 字段和表名处理添加`
	 * @access protected
	 * @param string $key
	 * @return string
	 */
	protected function parseKey(&$key) {
		$key = trim ( $key );
		if (! preg_match ( '/[,\'\"\*\(\)`.\s]/', $key )) {
			$key = '`' . $key . '`';
		}
		return $key;
	}
	
	/**
	 * 取得数据表的字段信息
	 * @access public
	 * @return array
	 */
	public function getFields($tableName) {
		$result = $this->query ( 'SHOW COLUMNS FROM ' . $this->parseKey ( $tableName ) );
		$info = array ();
		if ($result) {
			foreach ( $result as $key => $val ) {
				$unsigned = false;
				if (false !== strpos ( $val ['Type'], 'unsigned' )) {
					$unsigned = true;
				}
				
				$info [$val ['Field']] = array ('name' => $val ['Field'], 'unsigned' => $unsigned, 'null' => ( bool ) (strtoupper ( $val ['Null'] )), 'default' => $val ['Default'], 'primary_key' => (strtolower ( $val ['Key'] ) == 'pri'), 'auto_increment' => (strtolower ( $val ['Extra'] ) == 'auto_increment') );
				$typeArray = explode ( " ", $val ['Type'] );
				if (preg_match ( '@(.*)\((.+)\)@si', $typeArray [0], $regs )) {
					$info [$val ['Field']] ['type'] = trim ( $regs [1] );
					$info [$val ['Field']] ['length'] = trim ( $regs [2] );
				} else {
					$info [$val ['Field']] ['type'] = $typeArray [0];
				}
			}
		}
		return $info;
	}
	
	/**
	 * 取得数据库的表信息
	 * @access public
	 * @return array
	 */
	public function getTables($dbName = '') {
		if (! empty ( $dbName )) {
			$sql = 'SHOW TABLES FROM ' . $dbName;
		} else {
			$sql = 'SHOW TABLES ';
		}
		$result = $this->query ( $sql );
		$info = array ();
		foreach ( $result as $key => $val ) {
			$info [$key] = current ( $val );
		}
		return $info;
	}
	
	/**
	 * 数据库错误信息
	 * 并显示当前的SQL语句
	 * @access public
	 * @return string
	 */
	private function error() {
		$this->error = '';
		if ('' != $this->sql) {
			$this->error = 'SQL: ' . $this->sql;
		}
		$this->error .= "\r\n ERROR CODE " . mysql_errno () . ':' . mysql_error ( $this->connection );	
		Baifu::db_sql_error($this->error);
		return $this->error;
	}
	
	/**
	 * 遍历查询结果集
	 * @param $type	返回结果集类型  MYSQL_ASSOC，MYSQL_NUM 和 MYSQL_BOTH
	 * @return array
	 */
	private function fetch_array($type = MYSQL_ASSOC) {
		$res = mysql_fetch_array ( $this->resource, $type );
		if (! $res) {
			$this->free ();
		}
		return $res;
	}
	
	/**
	 * 获得所有的查询数据
	 * @access private
	 * @return array
	 */
	private function fetch_all() {
		$result = array ();
		if ($this->num_rows > 0) {
			while ( $row = mysql_fetch_assoc ( $this->resource ) ) {
				$result [] = $row;
			}
			mysql_data_seek ( $this->resource, 0 );
		}
		return $result;
	}
	/**
	 * 析构方法
	 * @access public
	 */
	public function __destruct() {
		if ($this->resource) {
			$this->free ();
		}
		$this->close ();
	}
}