<?php
class File{

    /**
     * 读取文件信息
     * @access public
     * @param string $filename  文件名
     * @return boolean     
     */
    static public function read($filename){
        if(!is_file($filename)) return false;
        return file_get_contents($filename);
    }
    /**
     * 文件写入
     * @access public
     * @param string $filename  文件名
     * @param string $content  文件内容
     * @return boolean         
     */
    static public function write($filename,$content){
        $dir         =  dirname($filename);
        if(!is_dir($dir))
            mkdir($dir,0755,true);
        if(false === file_put_contents($filename,$content)){
            return false;
        }else{
            return true;
        }
    }

    /**
     * 文件删除
     * @access public
     * @param string $filename  文件名
     * @return boolean     
     */
    static public function unlink($filename){
        return is_file($filename) ? unlink($filename) : false; 
    }
}
