<?php
/**
 * 表基类
 */
class  Table {
	/**
	 * 模型配置
	 */
	public $config =  array();
	/**
	 * 模型数据数组
	 */
	public $data =  array();
	/**
	 * 字段定义
	 */
	public $fields = array();
	/**
	 * 架构函数
	 * @param array $data 模型数据
	 */
    public function __construct($data=array()) {
		$this->setData($data);
    }
	/**
     * 得到完整的数据表名
     * @access public
     * @return string
     */
    public function getTableName() {
    	if(!$this->getConfig('tablename')) {
            $this->config['tablename']    =   strtolower(substr(get_class($this),0,-5));
        }
        $tableName  = $this->getConfig('db_prefix') ? $this->getConfig('db_prefix') : Config::get('database.db_prefix');
        $tableName .= $this->getConfig('tablename');
        return strtolower(($this->getConfig('db_name')?$this->getConfig('db_name').'.':'').$tableName);
    }
	/**
     * 得到当前的数据对象名称
     * @access public
     * @return string
     */
    public function getModelName() {
        if(empty($this->name))
            $this->name =   substr(get_class($this),0,-5);
        return $this->name;
    }
	/**
     * 设置模型配置的值
     * @access public
     * @param string $name 名称
     * @param mixed $value 值
     * @return void
     */
    public function setConfig($name,$value) {
        $this->config[$name]  =   $value;
    }
	/**
     * 获取模型配置对象的值
     * @access public
     * @param string $name 名称
     * @return mixed
     */
    public function getConfig($name) {
        return isset($this->config[$name])?$this->config[$name]:null;
    }
    /**
     * 设置模型数据
     * @param mixed $data 模型数据 支持对象 字符串 数组
     */
	public function setData($data) {
		if('' === $data && !empty($this->data)) {
            return $this->data;
        }
        if(is_object($data)){
            $data   =   get_object_vars($data);
        }elseif(is_string($data)){
            parse_str($data,$data);
        }elseif(!is_array($data)){
            ThrowException('数据类型错误');
        }
		$this->data=array_merge($this->data,$data);
    }
    /**
     * 获取所有模型值
     */
	public function getData() {
		return $this->data;
    }
    /**
     * 获取模型所有字段设置
     */
	public function getFields() {
		return $this->fields;
    }
/**
     * 设置数据对象的值
     * @access public
     * @param string $name 名称
     * @param mixed $value 值
     * @return void
     */
    public function __set($name,$value) {
        $this->data[$name]  =   $value;
    }

    /**
     * 获取数据对象的值
     * @access public
     * @param string $name 名称
     * @return mixed
     */
    public function __get($name) {
        return isset($this->data[$name])?$this->data[$name]:null;
    }

    /**
     * 检测数据对象的值
     * @access public
     * @param string $name 名称
     * @return boolean
     */
    public function __isset($name) {
        return isset($this->data[$name]);
    }

    /**
     * 销毁数据对象的值
     * @access public
     * @param string $name 名称
     * @return void
     */
    public function __unset($name) {
        unset($this->data[$name]);
    }
}

?>