<?php
defined('BAIFU_PATH') or exit('Access Denied');
/**
 * IP地理位置类
 */
class IpLocation
{
    /**
     * 根据所给 IP 地址或域名返回所在地区信息
     * @access public
     * @param string $ip
     * @return string
     */
    public static  function getlocation($ip='') {
    	if(empty($ip)) $ip=self::getClientIp();
		$sinaapi = 'http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=js&ip=' . $ip;
		$ipdata = @file_get_contents ( $sinaapi );
		if ($ipdata) {
			$ipdata = str_replace ( array ('var remote_ip_info = ', ';' ), array ('', '' ), $ipdata );
			$arr = json_decode ( $ipdata, true );
			$area = '';
			if (isset ( $arr ['country'] ) && strpos ( $ipdata, "\u4e2d\u56fd" ) === false)
				$area .= $arr ['country'];
			if (isset ( $arr ['province'] ))
				$area .= $arr ['province'];
			if (isset ( $arr ['city'] ))
				$area .= $arr ['city'];
			if (isset ( $arr ['isp'] ))
				$area .= $arr ['isp'];
			if ($area)
				return Encoding ( $area, 'UTF-8', 'GBK' );
		}
		
		return $ip;
	}
	
	private static  function getClientIp(){
	   if (getenv("HTTP_CLIENT_IP") && strcasecmp(getenv("HTTP_CLIENT_IP"), "unknown"))
		   $ip = getenv("HTTP_CLIENT_IP");
	   else if (getenv("HTTP_X_FORWARDED_FOR") && strcasecmp(getenv("HTTP_X_FORWARDED_FOR"), "unknown"))
		   $ip = getenv("HTTP_X_FORWARDED_FOR");
	   else if (getenv("REMOTE_ADDR") && strcasecmp(getenv("REMOTE_ADDR"), "unknown"))
		   $ip = getenv("REMOTE_ADDR");
	   else if (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], "unknown"))
		   $ip = $_SERVER['REMOTE_ADDR'];
	   else
		   $ip = "unknown";
	   return $ip;
	}
}
?>