<?php
defined ( 'BAIFU_PATH' ) or exit ( 'Access Denied' );
/**
 * Session类
 */
class Session {
	protected $config = array ();
	protected static $default = array ('type' => 'file', 'expire' => 3600, 'cache_limiter' => 'private, must-revalidate', 'auto_start' => TRUE );
	/** 
	 * 取得类实例
	 * @static
	 * @access public
	 * @return Template 返回类实例
	 */
	public static function instance($name = '', $config = array()) {
		$args = func_get_args ();
		static $_instance = array ();
		$identify = Guid ( $args );
		if (! isset ( $_instance [$identify] )) {
			$config = self::parseConfig ( $config );
			$o = new Session ();
			$o->init ( $config );
			$_instance [$identify] = $o;
		}
		return $_instance [$identify];
	}
	/**
	 * 解析配置
	 * @access public
	 * @param array $config 自定义配置
	 * @return string
	 */
	public static function parseConfig($config = array()) {
		
		return array_merge ( self::$default, array_change_key_case ( $config ) );
	}
	public function init($config = array()) {
		$this->config = array_merge ( $this->config, $config );
		
		if (isset ( $_REQUEST ['session_id'] )) {
			session_id ( $_REQUEST ['session_id'] );
		} elseif (isset ( $this->config ['id'] )) {
			session_id ( $this->config ['id'] );
		}
		
		ini_set ( 'session.auto_start', 0 );
		ini_set ( 'session.save_handler', 'files' );
		if (! isset ( $this->config ['path'] ))
			$this->config ['path'] = APP_FILE_PATH . 'session/';
		if (! is_dir ( $this->config ['path'] )) {
			Dir::create ( $this->config ['path'] );
		}
		session_save_path ( $this->config ['path'] );
		if (isset ( $this->config ['name'] ))
			session_name ( $this->config ['name'] );
		if (isset ( $this->config ['domain'] ))
			ini_set ( 'session.cookie_domain', $this->config ['domain'] );
		if (isset ( $this->config ['expire'] ))
			ini_set ( 'session.gc_maxlifetime', $this->config ['expire'] );
		if (isset ( $this->config ['use_trans_sid'] ))
			ini_set ( 'session.use_trans_sid', $this->config ['use_trans_sid'] ? 1 : 0 );
		if (isset ( $this->config ['use_cookies'] ))
			ini_set ( 'session.use_cookies', $this->config ['use_cookies'] ? 1 : 0 );
		if (isset ( $this->config ['cache_limiter'] ))
			session_cache_limiter ( $this->config ['cache_limiter'] );
		if (isset ( $this->config ['cache_expire'] ))
			session_cache_expire ( $this->config ['cache_expire'] );
		
		if (isset ( $this->config ['auto_start'] )) {
			@session_start ();
		}
	}
	public function pause() {
		session_write_close ();
	}
	public function start() {
		session_start ();
	}
	public function destroy() {
		$_SESSION = array ();
		session_unset ();
		session_destroy ();
	}
	public function regenerate() {
		session_regenerate_id ();
	}

}