<?php
/**
 *文件上传类
 */
class Upload {
	private $savePath = '';
	private $error = '';
	private $uploadFiles;
	public $type = 'default';
	private $config = array ('saverule' => 'time', 'isoverwrite' => false, 'isrename' => true, 'issubdir' => true, 'subdirtype' => 'date', 'subdirparams' => 'Ymd', 'types' => array ('default' => array ('allow' => 'swf|flv|gif|jpeg|jpg|png|7z|aiff|asf|avi|bmp|csv|doc|fla|flv|gif|gz|gzip|jpeg|jpg|mid|mov|mp3|mp4|mpc|mpeg|mpg|ods|odt|pdf|png|ppt|pxd|qt|ram|rar|rm|rmi|rmvb|rtf|sdc|sitd|swf|sxc|sxw|tar|tgz|tif|tiff|txt|vsd|wav|wma|wmv|xls|xml|zip', 'deny' => '', 'maxsize' => 2048, 'mimetype' => '' ), 'image' => array ('allow' => 'gif|jpeg|jpg|png', 'deny' => '', 'maxsize' => 2048 ), 'file' => array ('allow' => '7z|aiff|asf|avi|bmp|csv|doc|fla|flv|gif|gz|gzip|jpeg|jpg|mid|mov|mp3|mp4|mpc|mpeg|mpg|ods|odt|pdf|png|ppt|pxd|qt|ram|rar|rm|rmi|rmvb|rtf|sdc|sitd|swf|sxc|sxw|tar|tgz|tif|tiff|txt|vsd|wav|wma|wmv|xls|xml|zip', 'deny' => '', 'maxsize' => 2048 ), 'flash' => array ('allow' => 'swf|flv', 'deny' => '', 'maxsize' => 2048 ), 'media' => array ('allow' => 'aiff|asf|avi|bmp|fla|flv|gif|jpeg|jpg|mid|mov|mp3|mp4|mpc|mpeg|mpg|png|qt|ram|rm|rmi|rmvb|swf|tif|tiff|wav|wma|wmv', 'deny' => '', 'maxsize' => 2048 ) ) );
	public function __construct($type = '', $config = array()) {
		if (empty ( $type ) || ! in_array ( strtolower ( $type ), array_keys ( $this->config ) )) {
			$type = 'default';
		}
		$this->type = strtolower ( $type );
		$this->config = array_merge ( $this->config, Config::load ( 'upload' ), array_change_key_case ( $config ) );
		$this->savePath = APP_FILE_UPLOAD_PATH;
		$this->config ['savepath'] = APP_FILE_UPLOAD_DIR;
	}
	/**
	 * 获取当前类型配置信息
	 * @access public
	 * @param string $name 名称
	 * @return mixed
	 */
	public function getConfig($name) {
		if (NULL !== $this->config [$name]) {
			return $this->config [$name];
		}
		return $this->$name;
	}
	/**
	 * 设置数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @param mixed $value 值
	 * @return void
	 */
	public function __set($name, $value) {
		$this->config ['types'] [$this->type] [$name] = $value;
	}
	
	/**
	 * 获取数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return mixed
	 */
	public function __get($name) {
		return isset ( $this->config ['types'] [$this->type] [$name] ) ? $this->config ['types'] [$this->type] [$name] : null;
	}
	
	/**
	 * 检测数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return boolean
	 */
	public function __isset($name) {
		return isset ( $this->config ['types'] [$this->type] [$name] );
	}
	
	/**
	 * 销毁数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return void
	 */
	public function __unset($name) {
		unset ( $this->config ['types'] [$this->type] [$name] );
	}
	
	/*
     * 保存上传的文件
     */
	public function save($files = '', $isremote = false) {
		$savePath = $this->savePath;
		if (! is_dir ( $savePath )) {
			if (! Dir::create ( $savePath )) {
				$this->error = '上传目录' . $savePath . '不存在';
				return false;
			}
		} else {
			if (! Dir::is_writeable ( $savePath )) {
				$this->error = '上传目录' . $savePath . '不可写';
				return false;
			}
		}
		$fileInfo = array ();
		$isUpload = false;
		$files = $this->getFiles ( $files ? $files : $_FILES );
		foreach ( $files as $key => $file ) {
			if (! empty ( $file ['name'] )) {
				$file ['extension'] = $this->getEextension ( $file ['name'] );
				$file ['savepath'] = $savePath;
				$file ['savename'] = $this->getSaveName ( $file );
				$file ['path'] = $this->config ['savepath'] . $file ['savename'];
				$file ['isimage'] = $this->isimage ( $file );
				if ($file ['error'] !== 0) {
					$this->error ( $file ['error'] );
					return false;
				}
				if (! $this->checkSize ( $file ['size'] )) {
					$this->error = '上传文件大小不符！';
					return false;
				}
				
				if (! $this->checkMimetype ( $file ['type'] )) {
					$this->error = '上传文件MIME类型不允许！';
					return false;
				}
				if (! $this->checkEextension ( $file ['extension'] )) {
					$this->error = '上传文件类型不允许';
					return false;
				}
				
				if (! $this->checkUpload ( $file ['tmp_name'] )) {
					$this->error = '非法上传文件！';
					return false;
				}
				if (in_array ( strtolower ( $file ['extension'] ), array ('gif', 'jpg', 'jpeg', 'bmp', 'png', 'swf' ) ) && false === getimagesize ( $file ['tmp_name'] )) {
					$this->error = '非法图像文件';
					return false;
				}
				
				$filename = $file ['savepath'] . $file ['savename'];
				if (! move_uploaded_file ( $file ['tmp_name'], $filename ) && ! copy ( $file ['tmp_name'], $filename )) {
					$this->error = '文件上传保存错误！';
					return false;
				}
				if (Config::get ( 'default.chmod' ))
					@chmod ( $filename, Config::get ( 'default.chmod' ) );
				unset ( $file ['tmp_name'], $file ['error'] );
				$fileInfo [] = $file;
				$isUpload = true;
			}
		}
		
		if ($isUpload) {
			$this->uploadFiles = $fileInfo;
			return true;
		} else {
			$this->error = '没有选择上传文件';
			return false;
		}
	}
	function isimage($file) {
		return preg_match ( "/^(jpg|jpeg|gif|png|bmp)$/i", $file ['extension'] );
	}
	/**
	 * 转换上传文件数组变量为正确的方式
	 */
	private function getFiles($files) {
		$fileArray = array ();
		$n = 0;
		foreach ( $files as $file ) {
			if (is_array ( $file ['name'] )) {
				$keys = array_keys ( $file );
				$count = count ( $file ['name'] );
				for($i = 0; $i < $count; $i ++) {
					foreach ( $keys as $key ) {
						$values = array_values ( $file [$key] );
						$fileArray [$n] [$key] = $values [$i];
					}
					$n ++;
				}
			} else {
				$fileArray [$n] = $file;
				$n ++;
			}
		}
		return $fileArray;
	}
	
	/**
	 * 获得保存文件名
	 */
	private function getSaveName($file) {
		$rule = $this->config ['saverule'];
		if (empty ( $rule )) {
			$saveName = $file ['name'];
		} else {
			if (function_exists ( $rule )) {
				$saveName = $rule () . "." . $file ['extension'];
			} else {
				$saveName = $rule . "." . $file ['extension'];
			}
		}
		if ($this->config ['issubdir']) {
			$file ['savename'] = $saveName;
			$saveName = $this->getSubDir ( $file ) . '/' . $saveName;
		}
		$filepath = $file ['savepath'] . $saveName;
		if (! $this->config ['isoverwrite'] && is_file ( $filepath )) {
			if ($this->config ['isrename']) {
				$i = 1;
				while ( $i ) {
					$saveName = str_replace ( '.' . $file ['extension'], '(' . $i . ').' . $file ['extension'], $saveName );
					if (is_file ( $file ['savepath'] . $saveName )) {
						$i ++;
						continue;
					} else {
						break;
					}
				}
			} else {
				$this->error = '文件已经存在！' . $filepath;
				return false;
			}
		}
		
		return $saveName;
	}
	
	/**
	 * 获取子目录的名称
	 */
	private function getSubDir($file) {
		switch ($this->config ['subdirtype']) {
			case 'date' :
				$dir = date ( $this->config ['subdirparams'], time () );
				break;
			case 'hash' :
			default :
				$name = md5 ( $file ['savename'] );
				$dir = '';
				for($i = 0; $i < $this->config ['subdirparams']; $i ++) {
					$dir .= $name {$i} . '/';
				}
				break;
		}
		if (! is_dir ( $file ['savepath'] . $dir )) {
			Dir::create ( $file ['savepath'] . $dir );
		}
		return $dir;
	}
	
	/**
	 * 检查Mime数据类型
	 */
	private function checkMimetype($type) {
		$allow = $this->getConfig ( 'mimetype' );
		if (! empty ( $allow ))
			return in_array ( strtolower ( $type ), $allow );
		return true;
	}
	
	/**
	 * 检查扩展名
	 */
	private function checkEextension($ext) {
		$allow = $this->getConfig ( 'allow' );
		if ($allow && ! preg_match ( "/^(" . $allow . ")$/i", $ext ))
			return false;
		$deny = $this->getConfig ( 'deny' );
		if ($deny && preg_match ( "/^(" . $deny . ")$/i", $ext ))
			return false;
		if (preg_match ( "/^(php|phtml|php3|php4|jsp|exe|dll|cer|shtml|shtm|asp|asa|aspx|asax|ashx|cgi|fcgi|pl)$/i", $ext ))
			return false;
		return true;
	}
	/**
	 * 检查文件大小
	 */
	private function checkSize($size) {
		return $size > 0 && $size / 1024 < $this->getConfig ( 'maxsize' );
	}
	
	/**
	 * 检查文件是否非法提交
	 */
	private function checkUpload($filename) {
		return is_uploaded_file ( $filename );
	}
	
	/**
	 * 获取扩展名
	 */
	private function getEextension($filename) {
		$pathinfo = pathinfo ( $filename );
		return $pathinfo ['extension'];
	}
	
	/**
	 * 取得上传文件的信息
	 */
	public function getUploadFiles() {
		return $this->uploadFiles;
	}
	
	/**
	 * 获取错误代码信息
	 */
	protected function error($errorNo) {
		switch ($errorNo) {
			case 1 :
				$this->error = '上传的文件超过了 php.ini 中 upload_max_filesize 选项限制的值';
				break;
			case 2 :
				$this->error = '上传文件的大小超过了 HTML 表单中 MAX_FILE_SIZE 选项指定的值';
				break;
			case 3 :
				$this->error = '文件只有部分被上传';
				break;
			case 4 :
				$this->error = '没有文件被上传';
				break;
			case 6 :
				$this->error = '找不到临时文件夹';
				break;
			case 7 :
				$this->error = '文件写入失败';
				break;
			default :
				$this->error = '未知上传错误！';
		}
		return;
	}
	/**
	 * 取得最后一次错误信息
	 */
	public function getError() {
		return $this->error;
    }
}
?>