<?php
/**
 * HTML类
 */
class Html {
	/**
	 * 序列化属性
	 */
	public static function serializeAttributes($attributes=array())
	{
 		$attr = array();
		foreach($attributes as $key => $val)
			$attr[] = sprintf('%s="%s"', htmlspecialchars( (string)$key ), htmlspecialchars( (string)$val ));
		return implode(' ', $attr);
	}
	/**
	 * 根据名称生成ID
	 */
	public static function getIdFromName($name)
	{
		return str_replace(array('[',']'),array('_',''), $name);
	}
	/**
	 * 生成input标签
	 */
	public static function input($name,$value, $attributes=array())
	{
		$attributes['name']=$name;
		if(!isset($attributes['id'])) $attributes['id']=self::getIdFromName($name);
		$value = htmlspecialchars( (string)$value );
		return sprintf('<input value="%s" %s />', $value, self::serializeAttributes($attributes));
	}
	/**
	 * 生成单行文本
	 */
    public static function text($name,$value,$attributes=array())
    {
    	$attributes['type'] = 'text';
		return self::input($name,$value, $attributes);
    }
    /**
	 * 生成提交按钮
	 */
	public static function submit($name,$value,$attributes=array())
    {
    	$attributes['type'] = 'submit';
		return self::input($name,$value, $attributes);
    }
    /**
	 * 生成重置按钮
	 */
	public static function reset($name,$value,$attributes=array())
    {
    	$attributes['type'] = 'reset';
		return self::input($name,$value, $attributes);
    }
    /**
	 * 生成普通按钮
	 */
	public static function button($name,$value,$attributes=array())
    {
    	$attributes['type'] = 'button';
		return self::input($name,$value, $attributes);
    }
    /**
	 * 生成隐藏域
	 */
	public static function hidden($name,$value,$attributes=array())
    {
    	$attributes['type'] = 'hidden';
		return self::input($name,$value, $attributes);
    }
    /**
	 * 生成文件上传
	 */
	public static function file($name,$value,$attributes=array())
    {
    	$attributes['type'] = 'file';
		return self::input($name,$value, $attributes);
    }
    /**
	 * 生成密码输入框
	 */
	public static function password($name,$value,$attributes=array())
    {
    	$attributes['type'] = 'password';
		return self::input($name,$value, $attributes);
    }
    /**
	 * 生成单选
	 */
	public static function radio($name,$value,$options=array(),$attributes=array())
    {
    	$attributes['type'] = 'radio';
		$attributes['id'] = '';
		$attributes['class'] = self::getIdFromName($name);
		$html = "";
		foreach ($options as $val => $text)
		{
			if($val==$value){
				$attributes['checked']='checked';
			}else{
				unset($attributes['checked']);
			}
			$option = self::input($name,$val, $attributes);
			$html .= sprintf('<label>%s %s</label> ', $option, htmlspecialchars($text));
		}
		
		return $html;
		
    }
    /**
	 * 生成多选
	 */
	public static function checkbox($name,$value,$options=array(),$attributes=array())
    {
    	$attributes['type'] = 'checkbox';
		$attributes['id'] = '';
		if(!is_array($value)){
			if($value != '') $value = strpos($value, ',') ? explode(',', $value) : array($value);
		}
		$html = "";
		foreach ($options as $val => $text)
		{
			if(in_array($val, $value)){
				$attributes['checked']='checked';
			}else{
				unset($attributes['checked']);
			}
			$option = self::input($name,$val, $attributes);
			$html .= sprintf('<label>%s %s</label> ', $option, $text);
		}
		
		return $html;
    }
    /**
	 * 生成列表
	 */
	public static function select($name,$value,$options=array(),$attributes=array(),$label='')
    {
    	$attributes['name']=$name;
		if(!isset($attributes['id'])) $attributes['id']=self::getIdFromName($name);
		
		$html = array();
		if($label) $html[] = sprintf('<option value="">%s</option>',htmlspecialchars($label));
		foreach($options as $val => $text)
		{
			$option_attributes = array('value' => htmlspecialchars($val));
			if ($val == $value) $option_attributes['selected'] = 'selected';
			$html[] = sprintf('<option %s>%s</option>',
				self::serializeAttributes($option_attributes),
				htmlspecialchars($text));
		}
		
		return sprintf('<select %s>%s</select>',
			self::serializeAttributes($attributes),
			implode($html));	
    }
    /**
	 * 生成多行文本
	 */
	public static function textarea($name,$value,$attributes=array())
    {
    	if(is_string($attributes)) $attributes = unserialize($attributes);
    	$attributes['name']=$name;
    	if(!isset($attributes['id'])) $attributes['id']=self::getIdFromName($name);
		return sprintf('<textarea %s>%s</textarea>', self::serializeAttributes($attributes), $value);
    }
    /**
	 * 生成上传控件
	 */
	public static function upload($name,$value,$attributes=array())
    {
    	$attributes ['class'] .= isset($attributes['class'])?$attributes['class'].' baifu-upload':'baifu-upload';
		$attributes ['data-field']=$name;
		
    	$list = '';
    	if($value&&is_string($value)) $value=array(array('url'=>$value));
		foreach ( $value as $k => $v ) {
			$row='<input type="text" name="' .$name. '['.$v['id'].'][url]" value="' .$v['url']. '" class="upload-url m-r-10" readonly="true" size="50"/><input type="hidden" name="' .$name. '['.$v['id'].'][title]" value="' .$v['title']. '" class="upload-title"/><input type="hidden" name="' .$name. '['.$v['id'].'][sort]" value="' .$v['sort']. '" class="upload-sort"/><a class="btn btn-delete" href="javascript:;" title="删除"><i class="i i-remove"></i> 删除</a>';
			if($attributes ['data-type']=='image'||$attributes ['data-type']=='flash'){
				$row.='<a class="btn btn-preview" href="javascript:;" title="预览"><i class="i i-eye-open"></i> 预览</a>';
			}
			$list.='<div class="m-t-10 row upload-row">'.$row.'</div>';
		}
		
		return sprintf('<span %s><a class="btn btn-upload">上传</a><div class="uploadlist">%s</div></span>', self::serializeAttributes($attributes), $list);
    }
    /**
	 * 生成时间控件
	 */
	public static function datetimepicker($name,$value,$attributes=array())
    {
    	if(is_string($attributes)) $attributes = unserialize($attributes);
    	$attributes ['class'] .= isset($attributes['class'])?$attributes['class'].' baifu-datetimepicker':'baifu-datetimepicker';
		if(preg_match('/^\d+$/', $value)){
			$value = date ( $attributes ['data-format'], $value );
		}
    	return self::text($name,$value, $attributes);
    }
    /**
	 * 生成编辑器
	 */
	public static function editor($name,$value,$attributes=array())
    {
    	$attributes['name']=$name;
    	$attributes['cols']=80;
    	$attributes['rows']=10;
    	if(!isset($attributes['id'])) $attributes['id']=self::getIdFromName($name);
    	$attributes ['class'] .= isset($attributes['class'])?$attributes['class'].' baifu-editor':'baifu-editor';
		$value=htmlspecialchars($value);
    	return sprintf('<textarea %s>%s</textarea>', self::serializeAttributes($attributes), $value);
    }
}
