<?php
defined ( 'BAIFU_PATH' ) or exit ( 'Access Denied' );
/**
 * 模板解析类
 */
class Template {
	
	protected $config = array ('strip_whitespace' => FALSE, 'deny_php' => FALSE, 'cache_path' => APP_FILE_TEMPLATE_PATH, 'layout_file' => 'layout', 'layout_tag' => '[CONTENT]' );
	protected static $default = array ('name' => 'baifu' );
	/**
	 * 设置数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @param mixed $value 值
	 * @return void
	 */
	public function __set($name, $value) {
		$this->config [$name] = $value;
	}
	
	/**
	 * 获取数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return mixed
	 */
	public function __get($name) {
		return isset ( $this->config [$name] ) ? $this->config [$name] : null;
	}
	
	/**
	 * 检测数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return boolean
	 */
	public function __isset($name) {
		return isset ( $this->config [$name] );
	}
	
	/**
	 * 销毁数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return void
	 */
	public function __unset($name) {
		unset ( $this->config [$name] );
	}
	/** 
	 * 取得类实例
	 * @static
	 * @access public
	 * @return Template 返回类实例
	 */
	public static function instance($name = '', $config = array()) {
		$args = func_get_args ();
		static $_instance = array ();
		$identify = Guid ( $args );
		if (! isset ( $_instance [$identify] )) {
			$config = self::parseConfig ( $config );
			$o = new Template ();
			$o->init ( $config );
			$_instance [$identify] = $o;
		
		}
		return $_instance [$identify];
	}
	/**
	 * 获取模版文件 
	 */
	public static function path($action = '', $controller = '', $module = '', $theme = '') {
		if (strpos ( $action, '/' )) {
			list ( $action, $controller, $module, $theme ) = explode ( '/', $action );
		}
		$theme = $theme ? $theme : Config::get ( 'default.theme' );
		$module = $module ? $module : Baifu::get ( 'm' );
		$controller = $controller ? $controller : Baifu::get ( 'c' );
		$action = $action ? $action : Baifu::get ( 'a' );
		$layer = 'view';
		$paths = array ();
		$paths = array_merge ( $paths, array (APP_MODULES_PATH . $module . '/' . $layer . '/' . $theme . '/' . $controller, APP_MODULES_PATH . $module . '/' . $layer . '/' . $theme, APP_VIEW_PATH . $module . '/' . $theme . '/' . $controller, APP_VIEW_PATH . $theme . '/' . $controller, APP_VIEW_PATH . $theme ) );
		if ($theme != Config::get ( "default.theme" )) {
			$theme = Config::get ( "default.theme" );
			$paths = array_merge ( $paths, array (APP_MODULES_PATH . $module . '/' . $layer . '/' . $theme . '/' . $controller, APP_MODULES_PATH . $module . '/' . $layer . '/' . $theme, APP_VIEW_PATH . $module . '/' . $theme . '/' . $controller, APP_VIEW_PATH . $theme . '/' . $controller, APP_VIEW_PATH . $theme ) );
		}
		$templateFile = '';
		foreach ( $paths as $path ) {
			$templateFile = strtolower ( $path . '/' . $action . Config::get ( 'default.template_suffix' ) );
			if (file_exists ( $templateFile ))
				return $templateFile;
		}
		ThrowException ( '模板不存在[' . implode ( '/' . $action . Config::get ( 'default.template_suffix' ) . ' | ', $paths ) . ']' );
	}
	
	/**
	 * 解析配置
	 * @access public
	 * @param array $config 自定义配置
	 * @return string
	 */
	public static function parseConfig($config = array()) {
		if (is_string ( $config ))
			$config = array ('name' => $config );
		return array_merge ( self::$default, array_change_key_case ( $config ) );
	}
	public function init($config = array()) {
		$this->config = array_merge ( $this->config, $config );
	
	}
	/**
	 * 解析内容
	 * @param $string $content
	 * @return string
	 */
	private function compile($content) {
		if (empty ( $content ))
			return '';
		if ($this->config ['deny_php'] && false !== strpos ( $content, '<?php' )) {
			ThrowException ( '模板禁止使用PHP语法' );
		}
		$content = preg_replace ( "/([\n\r]+)\t+/s", "\\1", $content );
		$content = preg_replace ( "/\<\!\-\-\{(.+?)\}\-\-\>/s", "{\\1}", $content );
		$content = preg_replace ( "/\{template\s+(.+)\}/", "<?php include Template::instance('baifu')->parseTemplate(\\1);?>", $content );
		$content = preg_replace ( "/\{include\s+(.+)\}/", "<?php include \\1; ?>", $content );
		$content = preg_replace ( "/\{php\s+(.+)\}/", "<?php \\1?>", $content );
		$content = preg_replace ( "/\{if\s+(.+?)\}/", "<?php if(\\1) { ?>", $content );
		$content = preg_replace ( "/\{else\}/", "<?php } else { ?>", $content );
		$content = preg_replace ( "/\{elseif\s+(.+?)\}/", "<?php } elseif (\\1) { ?>", $content );
		$content = preg_replace ( "/\{\/if\}/", "<?php } ?>", $content );
		$content = preg_replace ( "/\{for\s+(.+?)\}/", "<?php for(\\1) { ?>", $content );
		$content = preg_replace ( "/\{\/for\}/", "<?php } ?>", $content );
		$content = preg_replace ( "/\{\+\+(.+?)\}/", "<?php ++\\1; ?>", $content );
		$content = preg_replace ( "/\{\-\-(.+?)\}/", "<?php ++\\1; ?>", $content );
		$content = preg_replace ( "/\{(.+?)\+\+\}/", "<?php \\1++; ?>", $content );
		$content = preg_replace ( "/\{(.+?)\-\-\}/", "<?php \\1--; ?>", $content );
		$content = preg_replace ( "/\{loop\s+(\S+)\s+(\S+)\}/", "<?php \$n=1;if(is_array(\\1)) foreach(\\1 AS \\2) { ?>", $content );
		$content = preg_replace ( "/\{loop\s+(\S+)\s+(\S+)\s+(\S+)\}/", "<?php \$n=1; if(is_array(\\1)) foreach(\\1 AS \\2 => \\3) { ?>", $content );
		$content = preg_replace ( "/\{\/loop\}/", "<?php \$n++;}unset(\$n); ?>", $content );
		$content = preg_replace ( "/\{\{([^\}]*)\}\}/e", "\$this->parseInner('\\1')", $content );
		$content = preg_replace ( "/\{([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff:]*\(([^{}]*)\))\}/", "<?php echo \\1;?>", $content );
		$content = preg_replace ( "/\{\\$([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff:]*\(([^{}]*)\))\}/", "<?php echo \\1;?>", $content );
		$content = preg_replace ( "/\{(\\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)\}/", "<?php echo \\1;?>", $content );
		$content = preg_replace ( "/\{(\\$[a-zA-Z0-9_\[\]\'\"\$\x7f-\xff]+)\}/es", "self::addQuote('<?php echo \\1;?>')", $content );
		$content = preg_replace ( "/\{([A-Z_\x7f-\xff][A-Z0-9_\x7f-\xff]*)\}/s", "<?php echo \\1;?>", $content );
		$content = str_replace ( '?><?php', '', $content );
		$content = "<?php defined('BAIFU_PATH') or exit('Access Denied.'); ?>" . $content;
		return $content;
	
	}
	
	/**
	 * 编译解析模板文件
	 * @access public
	 * @param string $File 模板文件
	 * @param string|bool $layout 布局文件名
	 * @return string 编译解析后的缓存文件路径
	 */
	public function compileFile($file, $layout = false) {
		$cachefile = str_replace ( strtolower ( APP_PATH ), '', strtolower ( $file ) );
		$cacheValid = true;
		if ($layout) {
			if ($layout === true)
				$layout = $this->config ['layout_file'];
			$layoutFile = Template::path ( $layout );
			$cachefile = $this->config ['cache_path'] . $cachefile . '.' . $layout . '.tpl.php';
			if (filemtime ( $layoutFile ) > filemtime ( $cachefile )) {
				$cacheValid = false;
			}
		} else {
			$cachefile = $this->config ['cache_path'] . $cachefile . '.tpl.php';
		}
		if (! file_exists ( $cachefile ) || @filemtime ( $file ) > @filemtime ( $cachefile )) {
			$cacheValid = false;
		}
		if ($cacheValid === false) {
			$content = file_get_contents ( $file );
			if ($layout) {
				$layoutFile = Template::path ( $layout );
				$layoutFile = $this->compileFile ( $layoutFile );
				$content = str_replace ( $this->config ['layout_tag'], $content, file_get_contents ( $layoutFile ) );
			}
			$content = $this->compile ( $content );
			$dir = dirname ( $cachefile );
			if (! is_dir ( $dir ))
				mkdir ( $dir, 0755, true );
			if (false === file_put_contents ( $cachefile, trim ( $content ) ))
				ThrowException ( '文件不可写:' . $cachefile );
		}
		return $cachefile;
	
	}
	
	/**
	 * 解析模板标签
	 * @access protected
	 * @param string $template 模板文件规则
	 * @return string
	 */
	public function parseTemplate($action = '', $controller = '', $module = '', $theme = '') {
		if (file_exists ( $action )) {
			$path = $action;
		} else {
			$path = Template::path ( $action, $controller, $module, $theme );
		}
		return $this->compileFile ( $path );
	}
	/**
	 * 替换内部标签 <?php {{内部标签}} ?>
	 * @access private
	 * @param string $content  模板内容
	 * @return string|false
	 */
	private function parseInner($content) {
		$result = "'." . stripslashes ( stripslashes ( $content ) ) . ".'";
		return $result;
	}
	
	/**
	 * 为数组键添加双引号
	 * @param $var	转义的字符
	 * @return 转义后的字符
	 */
	public static function addQuote($var) {
		return str_replace ( "\\\"", "\"", preg_replace ( "/\[([a-zA-Z0-9_\-\.\x7f-\xff]+)\]/s", "['\\1']", $var ) );
	}
	/**
	 * 获取变量类似parse_str 可以解析引号
	 * @param $var	转义的字符
	 * @return 转义后的字符
	 */
	private function getVar($str) {
		$result = array ();
		preg_match_all ( "/([a-z]+)\=\"([^\"]+)\"/i", stripslashes ( $str ), $matches, PREG_SET_ORDER );
		foreach ( $matches as $v ) {
			$result [$v [1]] = $v [2];
		}
		return $result;
	}

}

?>
